IF OBJECT_ID('PG_FORN_PROC_MCC') IS NULL
begin
CREATE TABLE [dbo].[PG_FORN_PROC_MCC](
	[CD_EMP] [int] NOT NULL,
	[CD_FORN] [int] NOT NULL,
	[DT_PROC] [datetime] NOT NULL,
	[CD_USU] [int] NOT NULL,
	[ARQUIVO] [varbinary](max) NULL,
	[PROC_LIB_USU] [int] NOT NULL,
	[DT_CAD] [datetime] NOT NULL,
	[STS_PROC] [int] NOT NULL,
	[DT_IMP_INICIO] [datetime] NULL,
	[DT_IMP_FIM] [datetime] NULL,
	[DT_PROC_MCC_INI] [datetime] NULL,
	[DT_PROC_MCC_FIM] [datetime] NULL,
 CONSTRAINT [PK_PG_FORN_PROC_MCC] PRIMARY KEY CLUSTERED 
(
	[CD_EMP] ASC,
	[CD_FORN] ASC,
	[DT_PROC] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]


ALTER TABLE [dbo].[PG_FORN_PROC_MCC] ADD  CONSTRAINT [DF_PG_FORN_PROC_MCC_CD_EMP]  DEFAULT ((0)) FOR [CD_EMP]

ALTER TABLE [dbo].[PG_FORN_PROC_MCC] ADD  CONSTRAINT [DF_PG_FORN_PROC_MCC_CD_FORN]  DEFAULT ((0)) FOR [CD_FORN]

ALTER TABLE [dbo].[PG_FORN_PROC_MCC] ADD  CONSTRAINT [DF_PG_FORN_PROC_MCC_CD_USU]  DEFAULT ((0)) FOR [CD_USU]

ALTER TABLE [dbo].[PG_FORN_PROC_MCC] ADD  CONSTRAINT [DF_PG_FORN_PROC_MCC_PROC_LIB_USU]  DEFAULT ((0)) FOR [PROC_LIB_USU]

ALTER TABLE [dbo].[PG_FORN_PROC_MCC] ADD  CONSTRAINT [DF_PG_FORN_PROC_MCC_DT_CAD_1]  DEFAULT (getdate()) FOR [DT_CAD]

ALTER TABLE [dbo].[PG_FORN_PROC_MCC] ADD  CONSTRAINT [DF_PG_FORN_PROC_MCC_STS_PROC]  DEFAULT ((0)) FOR [STS_PROC]

ALTER TABLE [dbo].[PG_FORN_PROC_MCC]  WITH CHECK ADD  CONSTRAINT [FK_PG_FORN_PROC_MCC_PG_FORN] FOREIGN KEY([CD_EMP], [CD_FORN])
REFERENCES [dbo].[PG_FORN] ([CD_EMP], [CD_FORN])

ALTER TABLE [dbo].[PG_FORN_PROC_MCC] CHECK CONSTRAINT [FK_PG_FORN_PROC_MCC_PG_FORN]
end